% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{hline}
\alias{hline}
\title{Set horizontal borders}
\usage{
hline(x, i = NULL, j = NULL, border = NULL, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{border}{border properties defined by a call to \code{\link[=fp_border]{fp_border()}}}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
The function is applying an horizontal border to inner
content of one or all parts of a flextable. The lines are the
bottom borders of selected cells.
}
\examples{
library(officer)
std_border <- fp_border(color = "gray")

ft <- flextable(head(iris))
ft <- border_remove(x = ft)

# add horizontal borders
ft <- hline(ft, part = "all", border = std_border)
ft
}
\seealso{
Other borders management: 
\code{\link{border_inner}()},
\code{\link{border_inner_h}()},
\code{\link{border_inner_v}()},
\code{\link{border_outer}()},
\code{\link{border_remove}()},
\code{\link{hline_bottom}()},
\code{\link{hline_top}()},
\code{\link{surround}()},
\code{\link{vline}()},
\code{\link{vline_left}()},
\code{\link{vline_right}()}
}
\concept{borders management}
