% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_lin_pl_lin}
\alias{fn_lin_pl_lin}
\title{Linear plateau linear function}
\usage{
fn_lin_pl_lin(t, t1, t2, t3, k, beta)
}
\arguments{
\item{t}{Numeric. The time value.}

\item{t1}{Numeric. The lower threshold time. Default is 45.}

\item{t2}{Numeric. The upper threshold time before plateau. Default is 80.}

\item{t3}{Numeric. The lower threshold time after plateau. Default is 45.}

\item{k}{Numeric. The maximum value of the function. Default is 0.9.}

\item{beta}{Numeric. Slope of the linear decay.}
}
\value{
A numeric value based on the linear plateau linear model.
}
\description{
Linear plateau linear function
}
\details{
\if{html}{
\deqn{
f(t; t_1, t_2, t_3, k, \beta) =
\begin{cases}
0 & \text{if } t < t_1 \\
\dfrac{k}{t_2 - t_1} \cdot (t - t_1) & \text{if } t_1 \leq t \leq t_2 \\
k & \text{if } t_2 \leq t \leq t_3 \\
k + \beta \cdot (t - t_3) & \text{if } t > t_3
\end{cases}
}
}
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_lin_pl_lin",
  params = c(t1 = 38.7, t2 = 62, t3 = 90, k = 0.32, beta = -0.01),
  interval = c(0, 108),
  n_points = 2000,
  auc_label_size = 3
)
}
