% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_metrics.R
\name{metrics}
\alias{metrics}
\title{Metrics for an object of class \code{modeler}}
\usage{
metrics(x, by_grp = TRUE)
}
\arguments{
\item{x}{An object of class `modeler` containing the necessary data to compute the metrics.}

\item{by_grp}{Return the metrics by id? TRUE by default.}
}
\value{
A data frame containing the calculated metrics grouped by uid, metadata, and variables.
}
\description{
Computes various performance metrics for a modeler object.
The function calculates Sum of Squared Errors (SSE), Mean Absolute Error (MAE),
Mean Squared Error (MSE), Root Mean Squared Error (RMSE), and the Coefficient
of Determination (R-squared).
}
\details{
\if{html}{
Sum of Squared Errors (SSE):
\deqn{SSE = \sum_{i=1}^{n} (y_i - \hat{y}_i)^2}

Mean Absolute Error (MAE):
\deqn{MAE = \frac{1}{n} \sum_{i=1}^{n} |y_i - \hat{y}_i|}

Mean Squared Error (MSE):
\deqn{MSE = \frac{1}{n} \sum_{i=1}^{n} (y_i - \hat{y}_i)^2}

Root Mean Squared Error (RMSE):
\deqn{RMSE = \sqrt{\frac{1}{n} \sum_{i=1}^{n} (y_i - \hat{y}_i)^2}}

Coefficient of Determination (R-squared):
\deqn{R^2 = 1 - \frac{\sum_{i=1}^{n} (y_i - \hat{y}_i)^2}{\sum_{i=1}^{n} (y_i - \bar{y})^2}}
}
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_linear_sat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(1:2)
  )
plot(mod_1, id = c(1:2))
print(mod_1)
metrics(mod_1)
}
