% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_lin}
\alias{fn_lin}
\title{Linear function}
\usage{
fn_lin(t, m, b)
}
\arguments{
\item{t}{Numeric value.}

\item{m}{Numeric value for the slope coefficient.}

\item{b}{Numeric value for the intercept coefficient.}
}
\value{
A numeric value based on the linear function.
}
\description{
Computes a value based on a linear function.
}
\details{
\if{html}{
\deqn{
f(t; m, b) = m \cdot t + b
}
}
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_lin",
  params = c(m = 2, b = 10),
  interval = c(0, 108),
  n_points = 2000
)
}
