% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_read.R
\name{explorer}
\alias{explorer}
\title{Explore data}
\usage{
explorer(data, x, y, id, metadata)
}
\arguments{
\item{data}{A `data.frame` containing the input data for analysis.}

\item{x}{The name of the column in `data` that contains x points.}

\item{y}{The names of the columns in `data` that contain the variables to be analyzed.}

\item{id}{The names of the columns in `data` that contains a grouping variable.}

\item{metadata}{The names of the columns in `data` to keep across the analysis.}
}
\value{
An object of class \code{explorer}, which is a list containing the following elements:
\describe{
  \item{\code{summ_vars}}{A data.frame containing summary statistics for each trait at each x point, including minimum, mean, median, maximum, standard deviation, coefficient of variation, number of non-missing values, percentage of missing values, and percentage of negative values.}
  \item{\code{summ_metadata}}{A data.frame summarizing the metadata.}
  \item{\code{locals_min_max}}{A data.frame containing the local minima and maxima of the mean y values over x.}
  \item{\code{dt_long}}{A data.frame in long format, with columns for uid, metadata, var, x, and y}
  \item{\code{metadata}}{A character vector with the names of the variables to keep across.}
}
}
\description{
Explores data from a data frame in wide format.
}
\details{
This function helps to explore the dataset before being analyzed with \code{modeler()}.
}
\examples{
library(flexFitR)
data(dt_potato)
results <- dt_potato |>
  explorer(
    x = DAP,
    y = c(Canopy, GLI),
    id = Plot,
    metadata = c(gid, Row, Range)
  )
names(results)
head(results$summ_vars)
plot(results, label_size = 4, signif = TRUE, n_row = 2)
# New data format
head(results$dt_long)
}
