% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_filter.R
\name{fct_remove_levels}
\alias{fct_remove_levels}
\title{Remove Specified Levels from a Factor}
\usage{
fct_remove_levels(factor_vec, levels_to_remove, remove_na = TRUE)
}
\arguments{
\item{factor_vec}{A factor vector from which levels will be removed.}

\item{levels_to_remove}{A character vector of levels to be removed from the factor.}

\item{remove_na}{remove NA from the output? Default is \code{TRUE}.}
}
\value{
A factor vector with specified levels removed and remaining levels unchanged.
}
\description{
Removes specified levels from a factor vector, keeping the remaining levels and their order unchanged.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'cherry', 'date', 'fig', 'grape'))

# Remove levels 'banana' and 'date'
fct_remove_levels(factor_vec, levels_to_remove = c('banana', 'date'))
}
\author{
Kai Guo
}
