% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_join.R
\name{f_left_join}
\alias{f_left_join}
\alias{f_right_join}
\alias{f_inner_join}
\alias{f_full_join}
\alias{f_anti_join}
\alias{f_semi_join}
\alias{f_cross_join}
\alias{f_union_all}
\alias{f_union}
\title{Fast SQL joins}
\usage{
f_left_join(
  x,
  y,
  by = NULL,
  suffix = c(".x", ".y"),
  multiple = TRUE,
  keep = FALSE,
  ...
)

f_right_join(
  x,
  y,
  by = NULL,
  suffix = c(".x", ".y"),
  multiple = TRUE,
  keep = FALSE,
  ...
)

f_inner_join(
  x,
  y,
  by = NULL,
  suffix = c(".x", ".y"),
  multiple = TRUE,
  keep = FALSE,
  ...
)

f_full_join(
  x,
  y,
  by = NULL,
  suffix = c(".x", ".y"),
  multiple = TRUE,
  keep = FALSE,
  ...
)

f_anti_join(
  x,
  y,
  by = NULL,
  suffix = c(".x", ".y"),
  multiple = TRUE,
  keep = FALSE,
  ...
)

f_semi_join(
  x,
  y,
  by = NULL,
  suffix = c(".x", ".y"),
  multiple = TRUE,
  keep = FALSE,
  ...
)

f_cross_join(x, y, suffix = c(".x", ".y"), ...)

f_union_all(x, y, ...)

f_union(x, y, ...)
}
\arguments{
\item{x}{Left data frame.}

\item{y}{Right data frame.}

\item{by}{\code{character(1)} - Columns to join on.}

\item{suffix}{\code{character(2)} - Suffix to paste onto common cols
between \code{x} and \code{y} in the joined output.}

\item{multiple}{\code{logical(1)} - Should multiple matches be returned?
If \code{FALSE} the first match in y is used. Default is \code{TRUE}.}

\item{keep}{\code{logical(1)} - Should join columns from
both data frames be kept? Default is \code{FALSE}.}

\item{...}{Additional arguments passed to \code{collapse::join()}.}
}
\value{
A joined data frame, joined on the columns specified with \code{by}, using an
equality join.

\code{f_cross_join()} returns all possible combinations
between the two data frames.
}
\description{
Mostly a wrapper around \code{collapse::join()} that behaves more like
dplyr's joins. List columns, lubridate intervals and vctrs rcrds
work here too.
}
