% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runifRast.r
\name{runifRast,GRaster-method}
\alias{runifRast,GRaster-method}
\alias{runifRast}
\title{Create a raster with random values drawn from a uniform distribution}
\usage{
\S4method{runifRast}{GRaster}(x, n = 1, low = 0, high = 1, seed = NULL)
}
\arguments{
\item{x}{A \code{GRaster}. The output will have the same extent and dimensions as this raster.}

\item{n}{A numeric integer: Number of rasters to generate.}

\item{low, high}{Numeric: Minimum and maximum values from which to select.}

\item{seed}{Numeric integer vector or \code{NULL}: Random seed. If \code{NULL}, then a different seed will be generated by \strong{GRASS}. Defining this is useful if you want to recreate rasters.  If provided, there should be one seed value per raster.}
}
\value{
A \code{GRaster}.
}
\description{
\code{runifRast()} creates a raster with values drawn from a uniform (flat) distribution.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

### Create a raster with values drawn from a uniform distribution:
unif <- runifRast(elev)
plot(unif)

### Create a raster with values drawn from a normal distribution:
norms <- rnormRast(elev, n = 2, mu = c(5, 10), sigma = c(2, 1))
plot(norms)
hist(norms, bins = 100)

# Create a raster with random, seemingly normally-distributed values:
rand <- rSpatialDepRast(elev, dist = 1000)
plot(rand)

# Values appear normal on first inspection:
hist(rand)

# ... but actually are patterned:
hist(rand, bins = 100)

# Create a fractal raster:
fractal <- fractalRast(elev, n = 2, dimension = c(2.1, 2.8))
plot(fractal)
hist(fractal)

}
}
\seealso{
\code{\link[=rnormRast]{rnormRast()}}, \code{\link[=rSpatialDepRast]{rSpatialDepRast()}}, \code{\link[=fractalRast]{fractalRast()}}, \strong{GRASS} manual page for module \code{r.random.surface} (see \code{grassHelp("r.random.surface")})
}
