% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ruggedness.r
\name{ruggedness,GRaster-method}
\alias{ruggedness,GRaster-method}
\alias{ruggedness}
\title{Terrain ruggedness index}
\usage{
\S4method{ruggedness}{GRaster}(x)
}
\arguments{
\item{x}{A \code{GRaster}.}
}
\value{
A \code{GRaster}.
}
\description{
For a given focal grid cell, the terrain ruggedness index (TRI) is calculated by taking the square root of the average of the squared difference between the focal cell's elevation and the elevations of the 8 surrounding cells, or \deqn{\sqrt(\sum_{i = 1}^{8}(m_i - m_0)^2 / 8)} where \eqn{m_0} is the elevation of the focal cell and \eqn{m_i} is the elevation of the \emph{i}th grid cell.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Convert to GRaster:
elev <- fast(madElev)

# Terrain ruggedness index:
tri <- ruggedness(elev)
plot(c(elev, tri))

# Topographic wetness index:
twi <- wetness(elev)
plot(c(elev, twi))

}
}
\references{
Riley, S.J., DeGloria, S.D., and Elliot, R. 1999. A terrain ruggedness index that quantifies topographic heterogeneity. \emph{Intermountain Journal of Sciences} 5:23-27.
}
\seealso{
\code{\link[=terrain]{terrain()}}, \code{\link[=wetness]{wetness()}}, \code{\link[=geomorphons]{geomorphons()}}
}
