# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title PACalculationParameters
#' @description PACalculationParameters Class
#' @format An \code{R6Class} generator object
#' @field componentid  character 
#'
#' @field accounts  list( \link{PAIdentifier} ) [optional]
#'
#' @field benchmarks  list( \link{PAIdentifier} ) [optional]
#'
#' @field dates  \link{PADateParameters} [optional]
#'
#' @field groups  list( \link{PACalculationGroup} ) [optional]
#'
#' @field currencyisocode  character [optional]
#'
#' @field columns  list( \link{PACalculationColumn} ) [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
PACalculationParameters <- R6::R6Class(
  'PACalculationParameters',
  public = list(
    `componentid` = NULL,
    `accounts` = NULL,
    `benchmarks` = NULL,
    `dates` = NULL,
    `groups` = NULL,
    `currencyisocode` = NULL,
    `columns` = NULL,
    initialize = function(`componentid`, `accounts`=NULL, `benchmarks`=NULL, `dates`=NULL, `groups`=NULL, `currencyisocode`=NULL, `columns`=NULL, ...){
      local.optional.var <- list(...)
      if (!missing(`componentid`)) {
        stopifnot(is.character(`componentid`), length(`componentid`) == 1)
        self$`componentid` <- `componentid`
      }
      if (!is.null(`accounts`)) {
        stopifnot(is.vector(`accounts`), length(`accounts`) != 0)
        sapply(`accounts`, function(x) stopifnot(R6::is.R6(x)))
        self$`accounts` <- `accounts`
      }
      if (!is.null(`benchmarks`)) {
        stopifnot(is.vector(`benchmarks`), length(`benchmarks`) != 0)
        sapply(`benchmarks`, function(x) stopifnot(R6::is.R6(x)))
        self$`benchmarks` <- `benchmarks`
      }
      if (!is.null(`dates`)) {
        stopifnot(R6::is.R6(`dates`))
        self$`dates` <- `dates`
      }
      if (!is.null(`groups`)) {
        stopifnot(is.vector(`groups`), length(`groups`) != 0)
        sapply(`groups`, function(x) stopifnot(R6::is.R6(x)))
        self$`groups` <- `groups`
      }
      if (!is.null(`currencyisocode`)) {
        stopifnot(is.character(`currencyisocode`), length(`currencyisocode`) == 1)
        self$`currencyisocode` <- `currencyisocode`
      }
      if (!is.null(`columns`)) {
        stopifnot(is.vector(`columns`), length(`columns`) != 0)
        sapply(`columns`, function(x) stopifnot(R6::is.R6(x)))
        self$`columns` <- `columns`
      }
    },
    toJSON = function() {
      PACalculationParametersObject <- list()
      if (!is.null(self$`componentid`)) {
        PACalculationParametersObject[['componentid']] <-
          self$`componentid`
      }
      if (!is.null(self$`accounts`)) {
        PACalculationParametersObject[['accounts']] <-
          lapply(self$`accounts`, function(x) x$toJSON())
      }
      if (!is.null(self$`benchmarks`)) {
        PACalculationParametersObject[['benchmarks']] <-
          lapply(self$`benchmarks`, function(x) x$toJSON())
      }
      if (!is.null(self$`dates`)) {
        PACalculationParametersObject[['dates']] <-
          self$`dates`$toJSON()
      }
      if (!is.null(self$`groups`)) {
        PACalculationParametersObject[['groups']] <-
          lapply(self$`groups`, function(x) x$toJSON())
      }
      if (!is.null(self$`currencyisocode`)) {
        PACalculationParametersObject[['currencyisocode']] <-
          self$`currencyisocode`
      }
      if (!is.null(self$`columns`)) {
        PACalculationParametersObject[['columns']] <-
          lapply(self$`columns`, function(x) x$toJSON())
      }

      PACalculationParametersObject
    },
    fromJSON = function(PACalculationParametersJson) {
      PACalculationParametersObject <- jsonlite::fromJSON(PACalculationParametersJson)
      if (!is.null(PACalculationParametersObject$`componentid`)) {
        self$`componentid` <- PACalculationParametersObject$`componentid`
      }
      if (!is.null(PACalculationParametersObject$`accounts`)) {
        self$`accounts` <- ApiClient$new()$deserializeObj(PACalculationParametersObject$`accounts`, "array[PAIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(PACalculationParametersObject$`benchmarks`)) {
        self$`benchmarks` <- ApiClient$new()$deserializeObj(PACalculationParametersObject$`benchmarks`, "array[PAIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(PACalculationParametersObject$`dates`)) {
        datesObject <- PADateParameters$new()
        datesObject$fromJSON(jsonlite::toJSON(PACalculationParametersObject$dates, auto_unbox = TRUE, digits = NA))
        self$`dates` <- datesObject
      }
      if (!is.null(PACalculationParametersObject$`groups`)) {
        self$`groups` <- ApiClient$new()$deserializeObj(PACalculationParametersObject$`groups`, "array[PACalculationGroup]", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(PACalculationParametersObject$`currencyisocode`)) {
        self$`currencyisocode` <- PACalculationParametersObject$`currencyisocode`
      }
      if (!is.null(PACalculationParametersObject$`columns`)) {
        self$`columns` <- ApiClient$new()$deserializeObj(PACalculationParametersObject$`columns`, "array[PACalculationColumn]", loadNamespace("factset.analyticsapi.engines"))
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`componentid`)) {
        sprintf(
        '"componentid":
          "%s"
                ',
        self$`componentid`
        )},
        if (!is.null(self$`accounts`)) {
        sprintf(
        '"accounts":
        [%s]
',
        paste(sapply(self$`accounts`, function(x) jsonlite::toJSON(x$toJSON(), auto_unbox=TRUE, digits = NA)), collapse=",")
        )},
        if (!is.null(self$`benchmarks`)) {
        sprintf(
        '"benchmarks":
        [%s]
',
        paste(sapply(self$`benchmarks`, function(x) jsonlite::toJSON(x$toJSON(), auto_unbox=TRUE, digits = NA)), collapse=",")
        )},
        if (!is.null(self$`dates`)) {
        sprintf(
        '"dates":
        %s
        ',
        jsonlite::toJSON(self$`dates`$toJSON(), auto_unbox=TRUE, digits = NA)
        )},
        if (!is.null(self$`groups`)) {
        sprintf(
        '"groups":
        [%s]
',
        paste(sapply(self$`groups`, function(x) jsonlite::toJSON(x$toJSON(), auto_unbox=TRUE, digits = NA)), collapse=",")
        )},
        if (!is.null(self$`currencyisocode`)) {
        sprintf(
        '"currencyisocode":
          "%s"
                ',
        self$`currencyisocode`
        )},
        if (!is.null(self$`columns`)) {
        sprintf(
        '"columns":
        [%s]
',
        paste(sapply(self$`columns`, function(x) jsonlite::toJSON(x$toJSON(), auto_unbox=TRUE, digits = NA)), collapse=",")
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(PACalculationParametersJson) {
      PACalculationParametersObject <- jsonlite::fromJSON(PACalculationParametersJson)
      self$`componentid` <- PACalculationParametersObject$`componentid`
      self$`accounts` <- ApiClient$new()$deserializeObj(PACalculationParametersObject$`accounts`, "array[PAIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      self$`benchmarks` <- ApiClient$new()$deserializeObj(PACalculationParametersObject$`benchmarks`, "array[PAIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      self$`dates` <- PADateParameters$new()$fromJSON(jsonlite::toJSON(PACalculationParametersObject$dates, auto_unbox = TRUE, digits = NA))
      self$`groups` <- ApiClient$new()$deserializeObj(PACalculationParametersObject$`groups`, "array[PACalculationGroup]", loadNamespace("factset.analyticsapi.engines"))
      self$`currencyisocode` <- PACalculationParametersObject$`currencyisocode`
      self$`columns` <- ApiClient$new()$deserializeObj(PACalculationParametersObject$`columns`, "array[PACalculationColumn]", loadNamespace("factset.analyticsapi.engines"))
      self
    }
  )
)
