% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom_param.R
\name{binom_param}
\alias{binom_param}
\title{Binomial Parameters}
\usage{
binom_param(n, p, mean = NA, sd = NA, norm = NA, pois = NA, tol = 1e-06)
}
\arguments{
\item{n}{integer: vector number of observations}

\item{p}{numeric: vector of probabilities}

\item{mean}{integer or numeric: number of digits the mean should have}

\item{sd}{integer or numeric: number of digits the standard deviation should have}

\item{norm}{logical or function: normal approximation possible}

\item{pois}{logical or function: poisson approximation possible}

\item{tol}{numeric: the tolerance for numerical comparison (default: `1e-6)}
}
\value{
a data frame with possible choices of \code{n} , \code{p}, \code{mean} and \code{sd}
}
\description{
Generates a data frame with potential values for \code{size} and \code{prob},
and is subjected to specific conditions:
\itemize{
\item If \code{length(mean) == 1} and it's an integer, it signifies the desired number of digits for the mean.
\item If \code{mean} is set to \code{NA} (the default), all means are permissible.
\item When \code{length(mean) > 1}, the product \code{size * prob} must be one of the valid means.
\item The same rules applies to \code{sd}.
}
The parameters \code{norm} and \code{pois} can take on values of \code{NA}, \code{TRUE}, \code{FALSE},
or be defined as a function in the format: \verb{function(size, prob)}.
These values determine which \verb{(size, prob)} combinations are eligible:
\itemize{
\item For \code{NA}, all combinations of \verb{(size, prob)} are acceptable.
\item If specified as a function, only those combinations for which the function returns \code{TRUE} are considered valid.
\item If set to \code{TRUE}, combinations are accepted only if they satisfy either the condition \code{size * prob * (1 - prob) > 9}
(for \code{norm}, indicating a normal distribution approximation), or the conditions \code{prob < 0.05} and \code{n > 10}
(for \code{pois}, implying a Poisson distribution approximation).
\item If set to \code{FALSE}, the approximations should not hold for any combination.
}
Please be aware that there is no guarantee that the resulting data frame will include a valid solution.
}
\examples{
binom_param(1000:50000, (5:25)/100, 0, 0)
}
