% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_string.R
\name{as_string}
\alias{as_string}
\alias{lstring}
\alias{as_obs}
\alias{lobs}
\alias{as_sum}
\alias{as_fraction}
\alias{lfrac}
\title{Vector to String Conversion}
\usage{
as_string(txt, collapse = ", ", last = ", and ")

as_sum(txt)

as_obs(txt, name = "x", sorted = FALSE, ...)

as_fraction(val, latex = FALSE, sorted = FALSE, ...)

lobs(txt, name = "x", sorted = FALSE, ...)

lstring(txt, collapse = ", ", last = ", and ")

lfrac(val, latex = FALSE, sorted = FALSE, ...)
}
\arguments{
\item{txt}{vector: (character) vector to merge}

\item{collapse}{character: glues text between elements (default: \code{", "})}

\item{last}{character: glues text between the two last elements (default: \code{", and "})}

\item{name}{character: observation name (default: \code{"x"})}

\item{sorted}{logical: sorted or not sorted observations  (default: \code{FALSE})}

\item{...}{further parameters (given from \code{as_obs} to \code{as_string})}

\item{val}{numeric: values to convert into fractions}

\item{latex}{logical use of LaTeX \code{\\frac{.}{.}} or not (default: \code{FALSE})}
}
\value{
a string
}
\description{
Converts a character vector into a single string.
}
\examples{
x <- runif(5)
y <- c(TRUE, FALSE, NA) 
as_string(x)
as_string(y)
# toString
as_string(as.character(x))
as_string(as.character(y))
#
as_obs(x)
as_obs(sort(x), sorted=TRUE)
#
x <- round(runif(5), 2)
as_fraction(x)
as_fraction(x, TRUE)
#
y <- round(runif(5), 2)
as_sum(x)
}
