% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.R
\name{t2norm}
\alias{t2norm}
\alias{approx_binom2norm}
\alias{approx_clt2norm}
\alias{approx_t2norm}
\alias{binom2norm}
\alias{clt2norm}
\title{Approximations}
\usage{
t2norm(n, c = getOption("distribution.t2norm", 30))

binom2norm(
  size,
  prob,
  c = getOption("distribution.binom2norm", 9),
  type = c("single", "double")
)

clt2norm(n, c = getOption("distribution.clt2norm", 30))

approx_binom2norm(
  size,
  prob,
  c = getOption("distribution.binom2norm", 9),
  type = c("single", "double")
)

approx_clt2norm(n, c = getOption("distribution.clt2norm", 30))

approx_t2norm(n, c = getOption("distribution.t2norm", 30))
}
\arguments{
\item{n}{integer: number of observations}

\item{c}{numeric: approximation parameter (default: \verb{getOption("distribution.APPROXFUN)} or a default value)}

\item{size}{integer: number of observations}

\item{prob}{numeric: probability of success on each trial}

\item{type}{character: approximation condition used}
}
\value{
logical if the approximation would be possible
}
\description{
Functions which deliver \code{TRUE} or \code{FALSE} if any approximation if possible.
The approximation parameter \code{c} can be set directly, or it can be given via \code{getOption}. The approximation functions deliver \code{TRUE} in the following scenarios:
\itemize{
\item \code{t2norm}: \code{n>c} with \code{c=30}
\item \code{binom2norm}: if the \code{type} is \code{"single"} (default) then it checks \verb{size × prob (1-prob)>c}, or else it checks \verb{size × prob>c} and \verb{size × (1-prob)>c} with \code{c=9}
\item \code{clt2norm}: \code{n>c} with \code{c=30}. Note that the existence of the expectation and variance, which are required by the Central Limit Theorem, cannot be checked.
``
}
}
\examples{
# check for 5 observations
t2norm(n=c(5,50))
binom2norm(size=c(5,50), prob=0.5)
binom2norm(size=c(5,50), prob=0.5, type="double")
}
