% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch02TestItemAnalysis.R
\name{JCRR}
\alias{JCRR}
\title{Joint Correct Response Rate}
\usage{
JCRR(U, na = NULL, Z = NULL, w = NULL, ...)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{...}{Internal parameters for maintaining compatibility with the binary data
processing system. Not intended for direct use.}
}
\value{
A matrix of joint correct response rates with exametrika class.
Each element (i,j) represents the proportion of students who correctly
answered both items i and j.
}
\description{
The joint correct response rate (JCRR) is the rate of students who passed
both items. This function is applicable only to binary response data.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# example code
# Calculate JCRR using sample dataset J5S10
JCRR(J5S10)
}
