% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch02TestItemAnalysis.R
\name{ItemLift}
\alias{ItemLift}
\title{Item Lift}
\usage{
ItemLift(U, na = NULL, Z = NULL, w = NULL, ...)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{...}{Internal parameters for maintaining compatibility with the binary data
processing system. Not intended for direct use.}
}
\value{
A matrix of item lift values with exametrika class.
Each element (j,k) represents the lift value of item k given item j,
which indicates how much more likely item k is to be correct given that
item j was answered correctly.
}
\description{
The lift is a commonly used index in a POS data analysis.
The item lift of Item k to Item j is defined as follow:
\eqn{ l_{jk} = \frac{p_{k\mid j}}{p_k} }
This function is applicable only to binary response data.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# example code
# Calculate ItemLift using sample dataset J5S10
ItemLift(J5S10)
}
\references{
Brin, S., Motwani, R., Ullman, J., & Tsur, S. (1997). Dynamic itemset counting and
implication rules for market basket data. In Proceedings of ACM SIGMOD International Conference
on Management of Data (pp. 255–264). https://dl.acm.org/doi/10.1145/253262.253325
}
