% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_gls.R
\name{plot.rate_gls}
\alias{plot.rate_gls}
\title{Plot of rate_gls object}
\usage{
\method{plot}{rate_gls}(
  x,
  scale = "SD",
  print_param = TRUE,
  digits_param = 2,
  digits_rsquared = 1,
  main = "GLS regression",
  xlab = "x",
  ylab = "Response",
  col = "grey",
  cex.legend = 1,
  ...
)
}
\arguments{
\item{x}{An object of class \code{'rate_gls'}.}

\item{scale}{The scale of the y-axis, either the variance scale ('VAR'), that
is y^2, or the standard deviation scale ('SD'), that is abs(y).}

\item{print_param}{logical: if parameter estimates should be printed in the
plot or not.}

\item{digits_param}{The number of significant digits displayed for the
parameters in the plots.}

\item{digits_rsquared}{The number of decimal places displayed for the
r-squared.}

\item{main}{as in \code{\link{plot}}.}

\item{xlab}{as in \code{\link{plot}}.}

\item{ylab}{as in \code{\link{plot}}.}

\item{col}{as in \code{\link{plot}}.}

\item{cex.legend}{A character expansion factor relative to current par("cex")
for the printed parameters.}

\item{...}{Additional arguments passed to \code{\link{plot}}.}
}
\value{
\code{plot} returns a plot of the gls rate regression
}
\description{
\code{plot} method for class \code{'rate_gls'}.
}
\details{
Plots the gls rate regression fitted by the \code{\link{rate_gls}}
  function. The regression line gives the expected variance or standard
  deviation (depending on scale). The regression is linear on the variance
  scale.
}
\examples{
# See the vignette 'Analyzing rates of evolution'.
}
\author{
Geir H. Bolstad
}
