
<!-- README.md is generated from README.Rmd. Please edit that file -->

# eventstudyr <img src='man/figures/logo.png' align="right" height="139" />

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/eventstudyr)](https://CRAN.R-project.org/package=eventstudyr)
[![CRAN RStudio mirror
downloads](https://cranlogs.r-pkg.org/badges/grand-total/eventstudyr)](https://r-pkg.org/pkg/eventstudyr)
<!-- badges: end -->

## Overview

The **eventstudyr** package implements tools for estimating linear panel
event study models, following the recommendations in [Freyaldenhoven et
al. (2021)](https://www.nber.org/papers/w29170). Includes sup-t bands,
testing for key hypotheses, least wiggly path through the Wald region.
Allows instrumental variables estimation following [Freyaldenhoven et
al. (2019)](https://www.aeaweb.org/articles?id=10.1257/aer.20180609).

## Installation

``` r
# Install from CRAN
install.packages("eventstudyr")

# Install latest version from GitHub
install.packages("devtools")
devtools::install_github("JMSLab/eventstudyr")
```

## Usage

Find a minimal example below. For more examples see the package
[documentation](https://cran.r-project.org/package=eventstudyr/eventstudyr.pdf)
and
[vignette](https://cran.r-project.org/package=eventstudyr/vignettes/documentation.html).

``` r
library(eventstudyr)
set.seed(10) # for reproducibility of sup-t bands

estimates_ols <- EventStudy(
   estimator = "OLS",
   data = example_data,   # Use package sample data
   outcomevar = "y_smooth_m",
   policyvar = "z",
   idvar = "id",
   timevar = "t",
   controls = "x_r",
   pre = 0,  post = 4
)

plt <- EventStudyPlot(estimates = estimates_ols)
plt
```

<img src="man/figures/README-example-1.png" alt="Event-study plot using the example data of the package and default plotting options."  />

## Citation

Simon Freyaldenhoven, Christian Hansen, Jorge Pérez Pérez, and Jesse M.
Shapiro. “Visualization, Identification, and Estimation in the Panel
Event-Study Design.” [NBER Working Paper
No. 29170](https://www.nber.org/papers/w29170), August 2021.

Simon Freyaldenhoven, Christian Hansen, Jorge Pérez Pérez, Jesse M.
Shapiro, Veli M. Andirin, Richard Calvo, Santiago Hermo, Nathan Schor,
Emily Wang. “`eventstudyr` package.” Code and data repository at
<https://github.com/JMSLab/eventstudyr>, March 2023.

## Acknowledgments

Thank you to Eliana Sena Sarmiento and Melissa Wu for their excellent
work testing and reviewing `eventstudyr` prior to its public release.
