% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictEvent.R
\name{predictEvent}
\alias{predictEvent}
\title{Predict event}
\usage{
predictEvent(
  df = NULL,
  target_d,
  newSubjects = NULL,
  event_fit = NULL,
  dropout_fit = NULL,
  fixedFollowup = FALSE,
  followupTime = 365,
  pilevel = 0.9,
  nyears = 4,
  nreps = 500,
  showEnrollment = TRUE,
  showEvent = TRUE,
  showDropout = FALSE,
  showOngoing = FALSE,
  showsummary = TRUE,
  showplot = TRUE,
  by_treatment = FALSE,
  covariates_event = NULL,
  event_fit_with_covariates = NULL,
  covariates_dropout = NULL,
  dropout_fit_with_covariates = NULL,
  fix_parameter = FALSE
)
}
\arguments{
\item{df}{The subject-level enrollment and event data, including
\code{trialsdt}, \code{usubjid}, \code{randdt}, \code{cutoffdt},
\code{time}, \code{event}, and \code{dropout}. The data should also
include \code{treatment} coded as 1, 2, and so on, and
\code{treatment_description} for by-treatment prediction. By default,
it is set to \code{NULL} for event prediction at the design stage.}

\item{target_d}{The target number of events to reach in the study.}

\item{newSubjects}{The enrollment data for new subjects including
\code{draw} and \code{arrivalTime}. The data should also include
\code{treatment} for prediction by treatment. By default,
it is set to \code{NULL},
indicating the completion of subject enrollment.}

\item{event_fit}{The pre-fitted event model used to generate
predictions.}

\item{dropout_fit}{The pre-fitted dropout model used to generate
predictions. By default, it is set to \code{NULL},
indicating no dropout.}

\item{fixedFollowup}{A Boolean variable indicating whether a fixed
follow-up design is used. By default, it is set to \code{FALSE}
for a variable follow-up design.}

\item{followupTime}{The follow-up time for a fixed
follow-up design, in days. By default, it is set to 365.}

\item{pilevel}{The prediction interval level. By default,
it is set to 0.90.}

\item{nyears}{The number of years after the data cut for prediction.
By default, it is set to 4.}

\item{nreps}{The number of replications for simulation. By default,
it is set to 500. If \code{newSubjects} is not \code{NULL},
the number of draws in \code{newSubjects} should be \code{nreps}.}

\item{showEnrollment}{A Boolean variable to control whether or not to
show the number of enrolled subjects. By default, it is set to
\code{TRUE}.}

\item{showEvent}{A Boolean variable to control whether or not to
show the number of events. By default, it is set to
\code{TRUE}.}

\item{showDropout}{A Boolean variable to control whether or not to
show the number of dropouts. By default, it is set to
\code{FALSE}.}

\item{showOngoing}{A Boolean variable to control whether or not to
show the number of ongoing subjects. By default, it is set to
\code{FALSE}.}

\item{showsummary}{A Boolean variable to control whether or not to
show the prediction summary. By default, it is set to \code{TRUE}.}

\item{showplot}{A Boolean variable to control whether or not to
show the prediction plot. By default, it is set to \code{TRUE}.}

\item{by_treatment}{A Boolean variable to control whether or not to
predict event by treatment group. By default,
it is set to \code{FALSE}.}

\item{covariates_event}{The names of baseline covariates from the input
data frame to include in the event model, e.g., c("age", "sex").
Factor variables need to be declared in the input data frame.}

\item{event_fit_with_covariates}{The pre-fitted event model with
covariates used to generate event predictions for ongoing subjects.}

\item{covariates_dropout}{The names of baseline covariates from the input
data frame to include in the dropout model, e.g., c("age", "sex").
Factor variables need to be declared in the input data frame.}

\item{dropout_fit_with_covariates}{The pre-fitted dropout model with
covariates used to generate dropout predictions for ongoing subjects.}

\item{fix_parameter}{Whether to fix parameters at the maximum
likelihood estimates when generating new data for prediction.
Defaults to FALSE, in which case, parameters will be drawn from
their approximate posterior distribution.}
}
\value{
A list of prediction results which includes important
information such as the median, lower and upper percentiles for
the estimated day and date to reach the target number of events,
as well as simulated event data for both ongoing and new subjects.
The data for the prediction plot is also included
within this list.
}
\description{
Utilizes pre-fitted time-to-event and time-to-dropout models
to generate event and dropout times for ongoing subjects
and new subjects. It also provides a
prediction interval for the expected time to reach the target
number of events.
}
\details{
To ensure successful event prediction at the design stage, it is
important to provide the \code{newSubjects} data set.

To specify the event (dropout) model used during the design-stage event
prediction, the \code{event_fit} (\code{dropout_fit}) should be a list
with one element per treatment. For each treatment, the element should
include \code{w} to specify the weight of the treatment in a
randomization block, \code{model} to specify the event model
(exponential, weibull, log-logistic, log-normal, or piecewise
exponential), \code{theta} and \code{vtheta} to indicate
the parameter values and the covariance matrix. For the piecewise
exponential event (dropout) model, the list should also include
\code{piecewiseSurvivalTime} (\code{piecewiseDropoutTime}) to indicate
the location of knots. It should be noted that the model averaging
and spline options are not appropriate for use during the design stage.

Following the commencement of the trial, we obtain the event
model fit and the dropout model fit based on the observed data,
denoted as \code{event_fit} and \code{dropout_fit}, respectively.
These fitted models are subsequently utilized to generate event
and dropout times for both ongoing and new subjects in the trial.
}
\examples{

# Event prediction after enrollment completion

event_fit <- fitEvent(df = interimData2,
                      event_model = "piecewise exponential",
                      piecewiseSurvivalTime = c(0, 140, 352))

dropout_fit <- fitDropout(df = interimData2,
                          dropout_model = "exponential")

event_pred <- predictEvent(df = interimData2, target_d = 200,
                           event_fit = event_fit$fit,
                           dropout_fit = dropout_fit$fit,
                           pilevel = 0.90, nreps = 100)

}
\references{
Emilia Bagiella and Daniel F. Heitjan. Predicting analysis times in
randomized clinical trials. Stat in Med. 2001; 20:2055-2063.

Gui-shuang Ying and Daniel F. Heitjan. Weibull prediction of event
times in clinical trials. Pharm Stat. 2008; 7:107-120.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
