% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_value_from_ijk.R
\name{get.value.from.ijk}
\alias{get.value.from.ijk}
\title{Value of the volume at a selection of DICOM indices}
\usage{
get.value.from.ijk(ijk, vol, interpolate = TRUE, s.ijk = c(1, 1, 1))
}
\arguments{
\item{ijk}{Vector or 3-column matrix of DICOM indices.}

\item{vol}{"volume" class object.}

\item{interpolate}{Boolean, default to \code{TRUE}. If \code{interpolate = TRUE}, a
trilinear interpolation of the value of the voxels, relative to the values of
adjacent voxels, is performed.}

\item{s.ijk}{Vector of 3 positive numbers greater than or equal to 1,
representing the new voxel ijk-sizes in which averaging is calculated.}
}
\value{
Returns a vector of the values of the volume at the requested DICOM
indices.
}
\description{
The \code{get.value.from.ijk} function calculates the value of
a "volume" class object at DICOM indices i, j, k, whether they are
integers or not.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 4
patient <- toy.load.patient (modality = "rtdose", roi.name = "", 
                             dxyz = rep (step, 3), beam.nb = 3)
D <- patient$rtdose[[1]]
# isodose
Dmax <- max (D$vol3D.data, na.rm = TRUE)
Dmax
idx <- which (D$vol3D.data >= (Dmax -1) & D$vol3D.data <= (Dmax - 0.2))
ijk <- get.ijk.from.index (idx, D)
get.value.from.ijk (ijk, vol = D, interpolate = FALSE)
}
\seealso{
\link[espadon]{get.ijk.from.index}.
}
