% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc.R
\name{cc}
\alias{cc}
\alias{cc.default}
\alias{cc.character}
\alias{cc.factor}
\alias{cc.data.frame}
\title{Concatenation with Commas}
\usage{
\method{cc}{default}(object, conjunction = NULL, bracket = "",
  ellipsis = 10, oxford = FALSE, ...)

\method{cc}{character}(object, conjunction = NULL, bracket = "'",
  ellipsis = 10, oxford = FALSE, ...)

\method{cc}{factor}(object, conjunction = NULL, bracket = "'",
  ellipsis = 10, oxford = FALSE, ...)

\method{cc}{data.frame}(object, conjunction = NULL, ellipsis = 10,
  oxford = FALSE, ...)
}
\arguments{
\item{object}{The object with values to concatenate.}

\item{conjunction}{A string of the conjunction to separate the last value by or NULL.}

\item{bracket}{A string to bracket the values by.}

\item{ellipsis}{A count of the total number of values required to use an ellipsis.}

\item{oxford}{A flag indicating whether to use the Oxford comma (if conjunction).}

\item{...}{Unused}
}
\description{
Concatenates object values into a string with each value separated
by a comma and possibly the last value separated by a conjunction.
}
\examples{
cc(c(1,1,1:2))
cc(100:1)
cc(1:100, "and")
cc(100:1, "or", bracket = "|", ellipsis = 5, oxford = TRUE)
cc(mtcars)
}
\seealso{
\code{\link{co}}
}
