% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_aux.R
\name{.get_lfs}
\alias{.get_lfs}
\title{Calculate the Level Frequency Score (LFS)}
\usage{
.get_lfs(s, eq5d_version)
}
\arguments{
\item{s}{A character vector representing the EQ-5D state, e.g. 11123.}

\item{eq5d_version}{A character string specifying the version of EQ-5D, i.e. 3L or 5L.}
}
\value{
A character vector representing the calculated LFS.
}
\description{
This function calculates the Level Frequency Score (LFS) for a given EQ-5D state and a specified version of EQ-5D.
If at least one domain contains a missing entry, the whole LFS is set to be NA.
}
\examples{
.get_lfs("333", "3L") # returns 003
.get_lfs("333", "5L") # returns 00300
.get_lfs("12345", "5L") # returns 11111
}
