% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeEpmGridList.R
\name{summarizeEpmGridList}
\alias{summarizeEpmGridList}
\title{Summarize lists of epmGrid objects}
\usage{
summarizeEpmGridList(x, fun = mean)
}
\arguments{
\item{x}{a list of objects of class \code{epmGrid} or \code{sf} or \code{SpatRaster}.}

\item{fun}{a function to apply to grid cells across the list x.}
}
\value{
a single object of class \code{epmGrid} or \code{sf} or \code{SpatRaster}.
}
\description{
If a diversity metric was calculated for an epmGrid object
that contained a phylogenetic distribution, then a list of resulting
epmGrid objects was returned. This function will take that list, and 
apply a summary statistic, returning a single epmGrid object. 
If the input list is from \code{\link{betadiv_phylogenetic}}, then that
list of sf or SpatRaster objects can also be summarized with this function.
}
\details{
It is assumed that across the objects in list x,
the only difference is the values for the grid cells.
}
\examples{

tamiasEPM <- addPhylo(tamiasEPM, tamiasTreeSet)
tamiasEPM <- addTraits(tamiasEPM, tamiasTraits)

x <- gridMetrics(tamiasEPM, metric='meanPatristicNN')
z <- summarizeEpmGridList(x, fun = var)

# using a custom function
f <- function(y) sum(y) / length(y)

z <- summarizeEpmGridList(x, fun = f)

# works with square grid epmGrids too
tamiasEPM2 <- createEPMgrid(tamiasPolyList, resolution = 50000, 
	cellType = 'square', method = 'centroid')
tamiasEPM2 <- addPhylo(tamiasEPM2, tamiasTreeSet)
tamiasEPM2 <- addTraits(tamiasEPM2, tamiasTraits)

x <- gridMetrics(tamiasEPM2, metric='meanPatristicNN')

z <- summarizeEpmGridList(x, fun = median)

\donttest{
# With phylogenetic distribution

tamiasEPM <- addPhylo(tamiasEPM, tamiasTreeSet, replace = TRUE)
beta_phylo_turnover <- betadiv_phylogenetic(tamiasEPM, radius = 70000,
	component = 'turnover')

z <- summarizeEpmGridList(beta_phylo_turnover)

tamiasEPM2 <- createEPMgrid(tamiasPolyList, resolution = 50000,
	cellType = 'square', method = 'centroid')
tamiasEPM2 <- addPhylo(tamiasEPM2, tamiasTreeSet)

beta_phylo_turnover <- betadiv_phylogenetic(tamiasEPM2, radius = 70000,
		component = 'turnover')

z <- summarizeEpmGridList(beta_phylo_turnover, fun = median)


}
}
\author{
Pascal Title
}
