% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{connectDB}
\alias{connectDB}
\title{Connect to a database.}
\usage{
connectDB(
  dbname = system.file("extdata", "chinook.sqlite", package = utils::packageName()),
  drv = RSQLite::SQLite(),
  ...
)
}
\arguments{
\item{dbname}{\code{character(0)}}

\item{drv}{database driver}

\item{...}{arguments passed to \code{DBI::dbConnect}}
}
\value{
database connection
}
\description{
Connect to a database.
}
\details{
Connects by default to a test SQLite database originally obtained here:
\href{https://github.com/lerocha/chinook-database/blob/master/ChinookDatabase/DataSources/Chinook_Sqlite.sqlite}{chinook_git}
}
\examples{

conn <- connectDB()
DBI::dbDisconnect(conn)

}
