% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reformat.R
\name{reformat}
\alias{reformat}
\alias{reformat.default}
\alias{reformat.character}
\alias{reformat.factor}
\alias{reformat.list}
\title{Reformat Values}
\usage{
reformat(obj, ...)

\method{reformat}{default}(obj, format, ...)

\method{reformat}{character}(obj, format, ...)

\method{reformat}{factor}(obj, format, ...)

\method{reformat}{list}(obj, format, ...)
}
\arguments{
\item{obj}{(\code{character}, \code{factor} or \verb{list of data.frame}) to reformat.}

\item{...}{for compatibility between methods and pass additional special mapping to transform rules.
\itemize{
\item \code{.string_as_fct} (\code{flag}) whether the reformatted character object should be converted to factor.
\item \code{.to_NA} (\code{character}) values that should be converted to \code{NA}. For \code{factor}, the corresponding levels are
dropped. If \code{NULL}, the argument will be taken from the \code{to_NA}attribute of the rule.
\item \code{.drop} (\code{flag}) whether to drop empty levels. If \code{NULL}, the argument will be taken from the \code{drop}attribute of
the rule.
\item \code{.na_last} (\code{flag}) whether the level replacing \code{NA} should be last.
}}

\item{format}{(\code{rule}) or (\code{list}) of \code{rule} depending on the class of obj.}
}
\value{
(\code{character}, \code{factor} or \verb{list of data.frame}) with remapped values.
}
\description{
Reformat Values
}
\note{
When the rule is empty rule or when values subject to reformatting are absent from the object, no error is
raised. The conversion to factor if \code{.string_as_fct = TRUE}) is still carried out. The conversion of the levels
declared in \code{.to_NA} to \code{NA} values occurs after the remapping. \code{NA} values created this way are not affected by a
rule declaring a remapping of \code{NA} values. For factors, level dropping is the last step, hence, levels converted to
\code{NA} by the \code{.to_NA} argument, will be removed if \code{.drop} is \code{TRUE}. Arguments passed via \code{reformat} override the
ones defined during rule creation.

the variables listed under the \code{all_dataset} keyword will be reformatted with the corresponding rule in every
data set except where another rule is specified for the same variable under a specific data set name.
}
\examples{

# Reformatting of character.
obj <- c("a", "b", "x", NA, "")
attr(obj, "label") <- "my label"
format <- rule("A" = "a", "NN" = NA)

reformat(obj, format)
reformat(obj, format, .string_as_fct = FALSE, .to_NA = NULL)


# Reformatting of factor.
obj <- factor(c("first", "a", "aa", "b", "x", NA), levels = c("first", "x", "b", "aa", "a", "z"))
attr(obj, "label") <- "my label"
format <- rule("A" = c("a", "aa"), "NN" = c(NA, "x"), "Not_present" = "z", "Not_a_level" = "P")

reformat(obj, format)
reformat(obj, format, .na_last = FALSE, .to_NA = "b", .drop = FALSE)


# Reformatting of list of data.frame.
df1 <- data.frame(
  var1 = c("a", "b", NA),
  var2 = factor(c("F1", "F2", NA))
)

df2 <- data.frame(
  var1 = c("x", NA, "y"),
  var2 = factor(c("F11", NA, "F22"))
)

db <- list(df1 = df1, df2 = df2)

format <- list(
  df1 = list(
    var1 = rule("X" = "x", "N" = NA, .to_NA = "b")
  ),
  df2 = list(
    var2 = rule("f11" = "F11", "NN" = NA)
  ),
  all_datasets = list(
    var1 = rule("xx" = "x", "aa" = "a")
  )
)

reformat(db, format)
}
