% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{duckdb_read_csv}
\alias{duckdb_read_csv}
\title{Reads a CSV file into DuckDB}
\usage{
duckdb_read_csv(
  conn,
  name,
  files,
  header = TRUE,
  na.strings = "",
  nrow.check = 500,
  delim = ",",
  quote = "\\"",
  col.names = NULL,
  lower.case.names = FALSE,
  sep = delim,
  transaction = TRUE,
  ...
)
}
\arguments{
\item{conn}{A DuckDB connection, created by \code{dbConnect()}.}

\item{name}{The name for the virtual table that is registered or unregistered}

\item{files}{One or more CSV file names, should all have the same structure though}

\item{header}{Whether or not the CSV files have a separate header in the first line}

\item{na.strings}{Which strings in the CSV files should be considered to be NULL}

\item{nrow.check}{How many rows should be read from the CSV file to figure out data types}

\item{delim}{Which field separator should be used}

\item{quote}{Which quote character is used for columns in the CSV file}

\item{col.names}{Override the detected or generated column names}

\item{lower.case.names}{Transform column names to lower case}

\item{sep}{Alias for delim for compatibility}

\item{transaction}{Should a transaction be used for the entire operation}

\item{...}{Passed on to \code{\link[=read.csv]{read.csv()}}}
}
\value{
The number of rows in the resulted table, invisibly.
}
\description{
Directly reads a CSV file into DuckDB, tries to detect and create the correct schema for it.
This usually is much faster than reading the data into R and writing it to DuckDB.
}
\examples{
\dontshow{if (duckdb:::TEST_RE2) withAutoprint(\{ # examplesIf}
con <- dbConnect(duckdb())

data <- data.frame(a = 1:3, b = letters[1:3])
path <- tempfile(fileext = ".csv")

write.csv(data, path, row.names = FALSE)

duckdb_read_csv(con, "data", path)
dbReadTable(con, "data")

dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
