% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonality.R
\name{commonality}
\alias{commonality}
\title{Compute qq from tt}
\usage{
commonality(tt, m)
}
\arguments{
\item{tt}{Mass assignment set matrix}

\item{m}{Mass assignment}
}
\value{
f Commonality function
}
\description{
qq is the commonality function as a set function from the subsets of the frame to \eqn{[0,1]}. To evaluate it, input a set encoded in binary vector, so the commonality number at that set can be returned.
}
\examples{
x <- bca(tt = matrix(c(0,1,1,1,1,0,1,1,1),nrow = 3, byrow = TRUE),
m = c(0.2,0.5, 0.3), cnames = c("a", "b", "c"), varnames = "x", idvar = 1)
qq <- commonality(x$tt,x$spec[,2])
qq(c(1,0,0))
}
\author{
Peiyuan Zhu
}
