\name{dsldScatterPlot3D}
\alias{dsldScatterPlot3D}
\title{ScatterPlot3D in dsld}
\description{ Plotly 3D visualization of  a dataset on 3 axes, 
   with points color-coded on a 4th variable.}
\usage{
dsldScatterPlot3D(data, yNames, sName, sGroups = NULL, sortedBy =
  "Name", numGroups = 8, maxPoints = NULL, xlim = NULL,
  ylim = NULL, zlim = NULL, main = NULL, colors =
  "Paired", opacity = 1, pointSize = 8)}

\arguments{
  \item{data}{
  Data frame with at least 4 columns. 
  }
  \item{yNames}{
  Vector of the indices or names of the columns of the data frame to be 
  graphed on the 3 axes. 
  }
  \item{sName}{
  Index or name of the column that contains the groups for which the data
  will be grouped by. This will affect the colors of the points of the graph. 
  This column must be an R factor.
  }
  \item{sGroups}{
  Vector of the names of the groups for which the data will be grouped by. 
  Every value in the vector must exist in the \code{sName} column of the data
  frame.  If not supplied or is NULL, the function will create this 
  automatically according to the \code{sortedby} and \code{numgrps} parameters.
  By default, the function uses the 8 alphabetically first distinct groups 
  in the \code{sName} column.
  }
  \item{sortedBy}{
  Controls how \code{sGroups} is created automatically. If \code{sGroups} 
  is supplied, this does nothing. One of three values: "Name", "Frequency", 
  "Frequency-Descending". 
  
  "Name" gets the first values alphabetically.
  "Frequency" gets the most frequently occuring values.
  "Frequency-Descending" gets the least frequently occuring values.
  }
  \item{numGroups}{
  Number of  groups to be automatically generated by the function. If 
  \code{grpnames} is supplied, this does nothing. 
  }
  \item{maxPoints}{
  Limit to how many points may be displayed on the graph.
  There is no limit by default.
  }
  \item{xlim, ylim, zlim}{
  The x, y and z limits, each a vector with c(min, max).
  }
  \item{main}{
  The title of the graph. By default, the \code{sName} "vs. " 
  \code{yNames}.
  }
  \item{colors}{
  Either a colorbrewer2.org palette name (e.g. "YlOrRd" or "Blues"), 
  or a vector of colors to interpolate in hexadecimal   "#RRGGBB" format, 
  or a color interpolation function like colorRamp().
  }
  \item{opacity}{
  A value between 0 and 1.
  }
  \item{pointSize}{
  A value above 1.
  }
}

\details{

An interactive Plotly visualization will be created, with the three
variables specified in \code{yNames}.  Points will be color-coded
according to \code{sName}. The plot can be rotated etc. using the mouse.

}

\references{
   https://plotly.com/r/3d-scatter-plots/
}

\author{
J. Tran and B. Zarate
}

\examples{
data(lsa)
dsldScatterPlot3D(lsa,sName = "race1", 
   yNames=c("ugpa", "lsat","age"), xlim=c(2,4))
}

\value{No value, plot.}


