% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{total_effect}
\alias{total_effect}
\title{Calculate total effects}
\usage{
total_effect(object, n_lags = 4)
}
\arguments{
\item{object}{Output from \code{\link{dsem}}}

\item{n_lags}{Number of lags over which to calculate total effects}
}
\value{
A data frame listing the time-lag (lag), variable that is undergoing some 
exogenous change (from), and the variable being impacted (to), along with the 
total effect (total_effect) including direct and indirect pathways, and the
partial "direct" effect (direct_effect)
}
\description{
Calculate a data frame of total effects, representing the 
estimated effect of every variable on every other variable and any time-lag
from 0 (simultaneous effects) to a user-specified maximum lag.
}
\details{
Total effects are taken from the Leontief matrix \eqn{\mathbf{(I-P)^{-1}}},
where \eqn{\mathbf{P}} is the path matrix across variables and times.
}
