% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{gompertz_gradient}
\alias{gompertz_gradient}
\alias{gompertz_hessian}
\alias{gompertz_gradient_hessian}
\title{Gompertz function gradient and Hessian}
\usage{
gompertz_gradient(x, theta)

gompertz_hessian(x, theta)

gompertz_gradient_hessian(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, delta, eta, phi)}.}
}
\value{
Gradient or Hessian evaluated at the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
Gompertz function.
}
\details{
The Gompertz function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = exp(-exp(-eta * (x - phi)))}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{theta = c(alpha, delta, eta, phi)} and \code{eta > 0}. When \code{delta} is
positive (negative) the curve is monotonically increasing (decreasing).
}
