% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{dodgr_flows_disperse}
\alias{dodgr_flows_disperse}
\title{dodgr_flows_disperse}
\usage{
dodgr_flows_disperse(graph, from, dens, contract = FALSE, k = 2,
  heap = "BHeap", quiet = TRUE)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph (see Details)}

\item{from}{Vector or matrix of points \strong{from} which aggregate dispersed
flows are to be calculated (see Details)}

\item{dens}{Vectors of densities correponsing to the \code{from} points}

\item{contract}{If \code{TRUE}, calculate flows on contracted graph before
mapping them back on to the original full graph (recommended as this will
generally be much faster).}

\item{k}{Width coefficient of exponential diffusion function defined as
\code{exp(-d/k)}.  If value of \code{k<0} is given, a standard logistic
polynomial will be used.}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
\code{Radix}, Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}

\item{quiet}{If \code{FALSE}, display progress messages on screen.}
}
\value{
Modified version of graph with additonal \code{flow} column added.
}
\description{
Disperse flows throughout a network based on a input vectors of origin points
and associated densities
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 10)
dens <- rep (1, length (from)) # Uniform densities
graph <- dodgr_flows_disperse (graph, from = from, dens = dens)
# graph then has an additonal 'flows` column of aggregate flows along all
# edges. These flows are directed, and can be aggregated to equivalent
# undirected flows on an equivalent undirected graph with:
graph_undir <- merge_directed_flows (graph)
}
