% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bouts.R
\name{boutsMLEll.chooser}
\alias{boutsMLEll.chooser}
\alias{.bouts2MLEll}
\alias{.bouts3MLEll}
\title{Log likelihood function of parameters given observed data}
\usage{
boutsMLEll.chooser(x, x0, transformed = TRUE)

.bouts2MLEll(x, p, lambda0, lambda1)

.bouts3MLEll(x, p0, p1, lambda0, lambda1, lambda2)
}
\arguments{
\item{x}{numeric vector of independent data to be described by the
function.}

\item{x0}{numerical one-dimensional vector of coefficients.}

\item{transformed}{logical indicating whether coefficients need to be
transformed back to original scale to compute the negative log
likelihood.}

\item{p, lambda0, lambda1}{numeric: parameters of the model.}

\item{p0, p1, lambda2}{numeric: parameters of the model.}
}
\value{
\code{ll.chooser} returns the negative log likelihood function
    of the joint distribution.

numeric vector

numeric vector
}
\description{
This function defines a closure, where \code{x} will be the object
passed to it.
}
\section{Functions}{
\itemize{
\item \code{.bouts2MLEll}: Log likelihood function in a 2-process Poisson
mixture

\item \code{.bouts3MLEll}: Log likelihood function in a 3-process Poisson
mixture
}}

\keyword{internal}
