% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_time_units.R
\name{utils_time_units}
\alias{utils_time_units}
\title{Data Frame with Supported Time Units}
\usage{
utils_time_units(all_columns = FALSE, class = NULL)
}
\arguments{
\item{all_columns}{(optional, logical) If TRUE, all columns are returned. Default: FALSE}

\item{class}{(optional, class name). Used to filter rows and columns. Accepted values are "numeric", "Date", and "POSIXct". Default: NULL}
}
\value{
data frame
}
\description{
Returns a data frame with the names of the supported time units, the classes that can handle each time unit, and a the threshold used to identify what time units can be used when aggregating a time series.
}
\examples{

df <- utils_time_units()
head(df)
}
\seealso{
Other internal_time_handling: 
\code{\link{utils_as_time}()},
\code{\link{utils_coerce_time_class}()},
\code{\link{utils_is_time}()},
\code{\link{utils_new_time}()},
\code{\link{utils_time_keywords}()},
\code{\link{utils_time_keywords_dictionary}()},
\code{\link{utils_time_keywords_translate}()}
}
\concept{internal_time_handling}
