% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{psi_null_ls_cpp}
\alias{psi_null_ls_cpp}
\title{(C++) Null Distribution of the Dissimilarity Scores of Two Aligned Time Series}
\usage{
psi_null_ls_cpp(
  x,
  y,
  distance = "euclidean",
  repetitions = 100L,
  permutation = "restricted_by_row",
  block_size = 3L,
  seed = 1L
)
}
\arguments{
\item{x}{(required, numeric matrix) of same number of columns as 'y'.}

\item{y}{(required, numeric matrix) of same number of columns as 'x'.}

\item{distance}{(optional, character string) distance name from the "names"
column of the dataset \code{distances} (see \code{distances$name}). Default: "euclidean".}

\item{repetitions}{(optional, integer) number of null psi values to generate. Default: 100}

\item{permutation}{(optional, character) permutation method. Valid values are listed below from higher to lower randomness:
\itemize{
\item "free": unrestricted shuffling of rows and columns. Ignores block_size.
\item "free_by_row": unrestricted shuffling of complete rows. Ignores block size.
\item "restricted": restricted shuffling of rows and columns within blocks.
\item "restricted_by_row": restricted shuffling of rows within blocks.
}}

\item{block_size}{(optional, integer) block size in rows for
restricted permutation. A block size of 3 indicates that a row can only be permuted
within a block of 3 adjacent rows. Minimum value is 2. Default: 3.}

\item{seed}{(optional, integer) initial random seed to use for replicability. Default: 1}
}
\value{
numeric vector
}
\description{
Applies permutation methods to compute null distributions for
the psi scores of two time series observed at the same times.
NA values should be removed before using this function.
If the selected distance function is "chi" or "cosine", pairs of zeros should
be either removed or replaced with pseudo-zeros (i.e. 0.00001).
}
\seealso{
Other Rcpp_dissimilarity_analysis: 
\code{\link{psi_dtw_cpp}()},
\code{\link{psi_equation_cpp}()},
\code{\link{psi_ls_cpp}()},
\code{\link{psi_null_dtw_cpp}()}
}
\concept{Rcpp_dissimilarity_analysis}
