% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{albatross}
\alias{albatross}
\title{Flight Path Time Series of Albatrosses in The Pacific}
\format{
data frame
}
\usage{
data(albatross)
}
\description{
Daily mean flight path data of 4 individuals of Waved Albatross (Phoebastria irrorata) captured via GPS during the summer of 2008. Sf data frame with columns name, time, latitude, longitude, ground speed, heading, and (uncalibrated) temperature.

The full dataset at hourly resolution can be downloaded from \url{https://github.com/BlasBenito/distantia/blob/main/data_full/albatross.rda} (use the "Download raw file" button).
}
\examples{
#load as tsl
#scale al variables
#aggregate to daily resolution
#align all time series to same temporal span
tsl <- tsl_initialize(
  x = albatross,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_local
  ) |>
  tsl_aggregate(
    new_time = "days"
  )

if(interactive()){
  tsl_plot(
    tsl = tsl,
    guide_columns = 5
    )
}
}
\references{
\doi{10.5441/001/1.3hp3s250}
}
\seealso{
Other example_data: 
\code{\link{cities_coordinates}},
\code{\link{cities_temperature}},
\code{\link{covid_counties}},
\code{\link{covid_prevalence}},
\code{\link{eemian_coordinates}},
\code{\link{eemian_pollen}},
\code{\link{fagus_coordinates}},
\code{\link{fagus_dynamics}},
\code{\link{honeycomb_climate}},
\code{\link{honeycomb_polygons}}
}
\concept{example_data}
\keyword{datasets}
