% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/viz_hull.R, R/wrap_hull.R
\docType{methods}
\name{viz_hull}
\alias{viz_hull}
\alias{viz_hull-method}
\alias{wrap_hull}
\alias{wrap_hull-method}
\alias{viz_hull,numeric,numeric-method}
\alias{viz_hull,MultivariateAnalysis,missing-method}
\alias{viz_hull,MultivariateBootstrap,missing-method}
\alias{viz_hull,PCOA,missing-method}
\alias{wrap_hull,numeric,numeric-method}
\alias{wrap_hull,MultivariateAnalysis,missing-method}
\alias{wrap_hull,PCOA,missing-method}
\title{Convex Hulls}
\usage{
viz_hull(x, y, ...)

wrap_hull(x, y, ...)

\S4method{viz_hull}{numeric,numeric}(x, y, ..., group = NULL, color = NULL, fill = FALSE, symbol = FALSE)

\S4method{viz_hull}{MultivariateAnalysis,missing}(x, ..., group = NULL, color = NULL, fill = FALSE, symbol = FALSE)

\S4method{viz_hull}{MultivariateBootstrap,missing}(x, ..., color = FALSE, fill = FALSE, symbol = FALSE)

\S4method{viz_hull}{PCOA,missing}(x, ..., group = NULL, color = FALSE, fill = FALSE, symbol = FALSE)

\S4method{wrap_hull}{numeric,numeric}(x, y, group = NULL)

\S4method{wrap_hull}{MultivariateAnalysis,missing}(x, margin = 1, axes = c(1, 2), group = NULL, principal = TRUE)

\S4method{wrap_hull}{PCOA,missing}(x, axes = c(1, 2), group = NULL)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, \code{x} must be an object
from which to wrap observations (a \code{\linkS4class{CA}}, \code{\linkS4class{MCA}} or
\code{\linkS4class{PCA}} object).}

\item{...}{Further \link[graphics:par]{graphical parameters} to be passed to
\code{\link[graphics:polygon]{graphics::polygon()}}.}

\item{group}{A vector specifying the group an observation belongs to.}

\item{color}{The colors for borders (will be mapped to \code{group}).
Ignored if set to \code{FALSE}. If \code{NULL}, the default color scheme will be used.}

\item{fill}{The background colors (will be mapped to \code{group}).
Ignored if set to \code{FALSE}.}

\item{symbol}{A vector of symbols (will be mapped to \code{group}).
Ignored if set to \code{FALSE}.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions
for which to compute results.}

\item{principal}{A \code{\link{logical}} scalar: should principal coordinates be
used? If \code{FALSE}, standard coordinates are returned.}
}
\value{
\code{wrap_hull()} returns a \code{\link{data.frame}} of envelope \code{x} and \code{y} coordinates.
An extra column named \code{group} is added specifying the group an observation
belongs to.

\code{viz_hull()}is called for its side-effects: it results in a graphic being
displayed. Invisibly returns \code{x}.
}
\description{
Plots convex hull of a set of observations.
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_quali = "Species")

## Compute convex hull coordinates
hulls <- wrap_hull(X, margin = 1, group = "Species")

## Plot convex hulls
col <- c("#004488", "#DDAA33", "#BB5566")
viz_rows(X, extra_quali = iris$Species, color = col)
viz_hull(X, group = iris$Species, color = col)
}
\seealso{
Other envelopes: 
\code{\link{viz_confidence}()},
\code{\link{viz_ellipses}()},
\code{\link{viz_tolerance}()}
}
\author{
N. Frerebeau
}
\concept{envelopes}
