% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.sgl}
\alias{predict.sgl}
\title{Predict using one of the following object types: \code{"sgl"}, \code{"sgl_cv"}.}
\usage{
\method{predict}{sgl}(object, x, ...)
}
\arguments{
\item{object}{Object of one of the following classes: \code{"sgl"}, \code{"sgl_cv"}.}

\item{x}{Input data to use for prediction.}

\item{...}{further arguments passed to stats function.}
}
\value{
A list containing:
\item{response}{The predicted response. In the logistic case, this represents the predicted class probabilities.}
\item{class}{The predicted class assignments. Only returned if type = "logistic" in the \code{"sgl"} or \code{"sgl_cv"} object.}
}
\description{
Performs prediction from one of the following fits: \code{\link[=dfr_sgl]{dfr_sgl()}}, \code{\link[=dfr_sgl.cv]{dfr_sgl.cv()}}, \code{\link[=dfr_adap_sgl]{dfr_adap_sgl()}}, \code{\link[=dfr_adap_sgl.cv]{dfr_adap_sgl.cv()}}. The predictions are calculated for each \code{"lambda"} value in the path.
}
\examples{
# specify a grouping structure
groups = c(1,1,1,2,2,3,3,3,4,4)
# generate data
data = sgs::gen_toy_data(p=10, n=5, groups = groups, seed_id=3,group_sparsity=1)
# run DFR-SGL 
model = dfr_sgl(X = data$X, y = data$y, groups = groups, type="linear", lambda = 1, alpha=0.95, 
standardise = "l2", intercept = TRUE, verbose=FALSE)
# use predict function
model_predictions = predict(model, x = data$X)
}
\seealso{
\code{\link[=dfr_sgl]{dfr_sgl()}}, \code{\link[=dfr_sgl.cv]{dfr_sgl.cv()}}, \code{\link[=dfr_adap_sgl]{dfr_adap_sgl()}}, \code{\link[=dfr_adap_sgl.cv]{dfr_adap_sgl.cv()}}

Other SGL-methods: 
\code{\link{dfr_adap_sgl}()},
\code{\link{dfr_adap_sgl.cv}()},
\code{\link{dfr_sgl}()},
\code{\link{dfr_sgl.cv}()},
\code{\link{plot.sgl}()},
\code{\link{print.sgl}()}
}
\concept{SGL-methods}
