% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision.r
\name{datetime_precision}
\alias{datetime_precision}
\alias{datetime_precision.datetimeoffset}
\alias{datetime_precision.clock_calendar}
\alias{datetime_precision.clock_time_point}
\alias{datetime_precision.clock_zoned_time}
\alias{datetime_precision.nanotime}
\alias{precision_to_int}
\title{Datetime precision}
\usage{
datetime_precision(x, ...)

\method{datetime_precision}{datetimeoffset}(x, range = FALSE, unspecified = FALSE, ...)

\method{datetime_precision}{clock_calendar}(x, ...)

\method{datetime_precision}{clock_time_point}(x, ...)

\method{datetime_precision}{clock_zoned_time}(x, ...)

\method{datetime_precision}{nanotime}(x, ...)

precision_to_int(precision)
}
\arguments{
\item{x}{A datetime vector.  Either \code{\link[=datetimeoffset]{datetimeoffset()}}, a "clock" "calendar", or a "clock" "time".}

\item{...}{Used by some S3 methods.}

\item{range}{If \code{TRUE} return just the minimum and maximum "precision".}

\item{unspecified}{If \code{TRUE} use the smallest non-missing component's as the precision even
if there is a missing value for a larger component.}

\item{precision}{A datetime precision (as returned by \code{datetime_precision()}).}
}
\value{
\code{datetime_precision()} returns a character vector of precisions.
Depending on the object either "missing", "year", "quarter", "month", "week",
"day", "hour", "minute", "second", "millisecond", "microsecond", or "nanosecond".
\code{precision_to_int()} returns an integer vector.
}
\description{
\code{datetime_precision()} returns the "precision" of a datetime vector's datetimes.
\code{precision_to_int()} converts the precision to an integer.
}
\examples{
  dts <- as_datetimeoffset(c("2020", "2020-04-10", "2020-04-10T10:10"))
  datetime_precision(dts)
  datetime_precision(dts, range = TRUE)

  dt <- datetimeoffset(2020, NA_integer_, 10)
  datetime_precision(dt)
  datetime_precision(dt, unspecified = TRUE)

  precision_to_int("year") < precision_to_int("day")

  library("clock")
  datetime_precision(year_month_day(1918, 11, 11))
  datetime_precision(sys_time_now())
  datetime_precision(zoned_time_now(Sys.timezone()))
}
