% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_dataresource.R
\name{new_dataresource}
\alias{new_dataresource}
\title{Create a new Data Resource}
\usage{
new_dataresource(
  name,
  title = NULL,
  description = NULL,
  path = NULL,
  format = NULL,
  mediatype = NULL,
  encoding = NULL,
  bytes = NULL,
  hash = NULL,
  ...
)
}
\arguments{
\item{name}{The name of the Data Resource.}

\item{title}{The title of the Data Resource.}

\item{description}{The description of the Data Resource.}

\item{path}{the path of the Data Resource}

\item{format}{the format of the Data Resource}

\item{mediatype}{the mediatype of the Data Resource}

\item{encoding}{the encoding of the Data Resource}

\item{bytes}{the number of bytes of the Data Resource}

\item{hash}{the hash of the Data Resource}

\item{...}{additional arguments are added as additional properties. It is 
checked if these are valid.}
}
\value{
Returns a \code{dataresource} object which is a list with the properties of
the Data Resource.
}
\description{
Create a new Data Resource
}
\examples{
dir <- tempdir()
dp <- new_datapackage(dir, name = "test-package")

res <- new_dataresource(name = "iris")
dp_title(res) <- "The Iris Data Set"
dp_encoding(res) <- "UTF-8"
dp_mediatype(res) <- "text/csv"

# resource adds a resource if it doesn't yet exist or updates
# an existing resource
dp_resource(dp, "iris") <- res

\dontshow{
file.remove(file.path(dir, "datapackage.json"))
file.remove(dir)
}


}
