% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_datetime.R
\name{dp_to_datetime}
\alias{dp_to_datetime}
\title{Convert a vector to 'datetime' using the specified field descriptor}
\usage{
dp_to_datetime(x, fielddescriptor = list(), ...)
}
\arguments{
\item{x}{the vector to convert.}

\item{fielddescriptor}{the field descriptor for the field.}

\item{...}{passed on to other methods.}
}
\value{
Will return an \code{POSIXct} vector with \code{fielddescriptor} added as the
'fielddescriptor' attribute.
}
\description{
Convert a vector to 'datetime' using the specified field descriptor
}
\details{
When \code{fielddescriptor} is missing a default field descriptor is
generated.

For the default format `iso8601::iso8601todatetime` is used to convert. This
function allows more formats than the Data Package standard prescribes. When 
format equals "any" the default `as.POSIXct` function is used.

When \code{x} is numeric or integer, it is assumed that these are seconds
since the unix time epoch (1970-01-01T00:00:00).
}
