% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_generate_dataresource.R
\name{dp_generate_dataresource}
\alias{dp_generate_dataresource}
\title{Generate Data Resource for a dataset}
\usage{
dp_generate_dataresource(
  x,
  name,
  path = paste0(name, getextension(format)),
  format = "csv",
  mediatype = getmediatype(format),
  use_existing = FALSE,
  categories_type = c("regular", "resource"),
  categorieslist = iscategorieslist(x),
  ...
)
}
\arguments{
\item{x}{\code{data.frame} for which to generate the Data Resources.}

\item{name}{name of the Data Resource}

\item{path}{name of the file in which to store the dataset. This should be a
path relative to the location of the directory in which the Data Package in
which the Data Resource will be stored.}

\item{format}{the data format in which the data is stored.}

\item{mediatype}{mediatype of the data}

\item{use_existing}{use existing field descriptors if present.}

\item{categories_type}{how should categories be stored. See 
\code{\link{dp_generate_fielddescriptor}}.}

\item{categorieslist}{does the data resource function as a categories list
for fields in another data resource}

\item{...}{Currently ignored}
}
\value{
Returns a Data Resource object. 

Note that this function does not create the file at \code{path}. The export
of the Data Resource is automatically set to CSV.
}
\description{
Generate Data Resource for a dataset
}
\examples{
# generate an example dataset
dta <- data.frame(a = 1:3, b = factor(letters[1:3]))
resource <- dp_generate_dataresource(dta, "example")
print(resource)

}
