% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNWISdata.R
\name{countyCdLookup}
\alias{countyCdLookup}
\title{County code look up}
\usage{
countyCdLookup(state, county, outputType = "id")
}
\arguments{
\item{state}{could be character (full name, abbreviation, id), or numeric (id)}

\item{county}{could be character (name, with or without "County") or numeric (id)}

\item{outputType}{character can be "fullName", "tableIndex", "id", or "fullEntry".}
}
\description{
Function to simplify finding county and county code definitions. Used in \code{readNWISdata}
and \code{readNWISuse}.
}
\examples{
id <- countyCdLookup(state = "WI", county = "Dane")
name <- countyCdLookup(state = "OH", county = 13, output = "fullName")
index <- countyCdLookup(state = "Pennsylvania", county = "ALLEGHENY COUNTY", output = "tableIndex")
fromIDs <- countyCdLookup(state = 13, county = 5, output = "fullName")
already_correct <- countyCdLookup(county = "51001")
}
