% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_from_date.R
\name{build_date_factor}
\alias{build_date_factor}
\title{Date Factor}
\usage{
build_date_factor(data_set, type = "yearmonth")
}
\arguments{
\item{data_set}{A vector of date values}

\item{type}{One of {"year", "yearquarter", "yearmonth", "quarter", "month"}}
}
\description{
Map a vector of dates to a factor at one of these levels {"yearmonth", "yearquarter", "quarter", "month"}
}
\details{
The resulting vector is an ordered factor of the specified \code{type} (e.g. yearmonth)
}
\examples{
library(data.table)
data_set <- as.Date(c("2014-01-01", "2015-01-01", "2015-06-01"))
build_date_factor(data_set, type = "yearmonth")
build_date_factor(data_set, type = "yearquarter")
build_date_factor(data_set, type = "yearquarter")

}
