% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morse.R
\name{morse}
\alias{morse}
\title{Import \code{morse} model parameters}
\usage{
morse(
  file,
  find.SD = TRUE,
  find.IT = TRUE,
  reset.hb = TRUE,
  params = c("estim", "all"),
  mcmc.size
)
}
\arguments{
\item{file}{Path to .RData file}

\item{find.SD}{a logical value. If \code{TRUE}, it will try to find fitted parameters of the GUTS_SD model}

\item{find.IT}{a logical value. If \code{TRUE}, it will try to find fitted parameters of the GUTS_IT model}

\item{reset.hb}{a logical value. If \code{TRUE}, the background hazard rate \code{hb} is set to zero}

\item{params}{\code{character}, if \code{"estim"} is selected then only the fitted parameter set for each model
is returned, else for \code{"auto"} all parameter sets in the MCM chains are returned}

\item{mcmc.size}{optional \code{integer}, sets the maximum number of imported parameter sets per MCMC,
all parameters are imported by default}
}
\value{
vector of \code{parameter_set} objects
}
\description{
Loads GUTS model parameters which were fitted by the morse package.
}
\examples{
# import all parameter fits
try(morse("path/to/morse_fit.RData"))

# import parameters for a specific model
try(morse("path/to/morse_fit.RData", find.IT=TRUE, find.SD=FALSE))

# modify model objects
try(models \%>\% set_param(morse("path/to/morse_fit.RData")))
}
