% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_title}
\alias{body_add_title}
\title{Add a title to an \code{officer} document}
\usage{
body_add_title(
  doc,
  value,
  level = 1,
  squish = TRUE,
  style = getOption("crosstable_style_heading", "heading")
)
}
\arguments{
\item{doc}{the doc object (created with the \code{read_docx} function of \code{officer} package)}

\item{value}{a character string. See Section below for markdown support.}

\item{level}{the level of the title. See \code{styles_info(doc)} to know the possibilities.}

\item{squish}{Whether to squish the result (remove trailing and repeated spaces). Default to \code{TRUE}.}

\item{style}{the name of the title style. See \code{styles_info(doc)} to know the possibilities.}
}
\value{
The docx object \code{doc}
}
\description{
Add a title to an \code{officer} document
}
\section{Markdown support}{

In all \code{crosstable} helpers for \code{officer}, you can use the following Markdown syntax to format your text:
\itemize{
\item \emph{bold}: \code{"**text in bold**"}
\item *italics: \code{"*text in italics*"}
\item \emph{subscript}: \code{"Text in ~subscript~"}
\item \emph{superscript}: \code{"Text in ^superscript^"}
\item \emph{newline}: \verb{Before <br> After}
\item \emph{color}: \code{"<color:red>red text</color>"}
\item \emph{shade}: \code{"<shade:yellow>yellow text</shade>"} (background color)
\item \emph{font family}: \code{"<ff:symbol>symbol</ff>"} (
}

Note that the font name depends on your system language. For instant, in French, it would be \code{Symbol} with an uppercase first letter.

See the last example of \code{\link[=body_add_normal]{body_add_normal()}} for a practical case.
}

\examples{
library(officer)
library(crosstable)
library(dplyr)
doc = read_docx() \%>\%
   body_add_title("La table iris (nrow={nrow(iris)})", 1) \%>\%
   body_add_title("Description", 2) \%>\%
   body_add_normal("La table iris a ", ncol(iris), " colonnes.")
#write_and_open(doc)
}
\author{
Dan Chaltiel
}
