% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossnma.R
\name{crossnma}
\alias{crossnma}
\title{Run JAGS to fit cross NMA and NMR}
\usage{
crossnma(
  x,
  inits = NULL,
  n.adapt = 1000,
  n.burnin = floor(n.iter/2),
  n.iter = 2000,
  thin = max(1, floor((n.iter - n.burnin)/1000)),
  n.chains = 2,
  monitor = NULL,
  level.ma = x$level.ma,
  backtransf = x$backtransf,
  quiet = TRUE,
  n.thin = NULL
)
}
\arguments{
\item{x}{An object produced by \code{\link{crossnma.model}}.}

\item{inits}{A list of lists with \code{n.chains} elements; each
element contains initial values for each model parameter or a
function that generates starting values. Default is different
numbers in \code{.RNG.seed} and \code{.RNG.name =
"base::Mersenne-Twister"}.}

\item{n.adapt}{Number of adaptations for the MCMC chains.}

\item{n.burnin}{Number of burnin iterations for the MCMC
chains. Default is \code{n.iter / 2} which discards the first
half of the iterations.}

\item{n.iter}{Number of iterations to run each MCMC chain.}

\item{thin}{Thinning for the MCMC chains. Default is max(1,
floor((n.iter - n.burnin) / 1000)), that is only thinning if
there are more than 2000 iterations.}

\item{n.chains}{Number of MCMC chains.}

\item{monitor}{A character vector of the names of the parameters to
be monitored. Basic parameters (depends on the analysis) will be
automatically monitored and only additional parameters need to be
specified.}

\item{level.ma}{The level used to calculate credible intervals for
network estimates.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts. If \code{backtransf = TRUE},
results for \code{sm = "OR"} are presented as odds ratios rather
than log odds ratios, for example.}

\item{quiet}{A logical passed on to \code{\link{jags.model}}.}

\item{n.thin}{Deprecated argument (replaced by \code{thin}).}
}
\value{
An object of class \code{crossnma} which is a list containing the
following components:
\item{jagsfit}{An "rjags" object produced when rjags package used
  to run the JAGS model.}
\item{model}{The \code{crossnma.model} object obtained from
  \code{\link{crossnma.model}} which was used to run JAGS.}
\item{trt.key}{A table of treatment names and their correspondence
  to integers used in the JAGS model.}
\item{inits, n.adapt, n.burnin, n.iter}{As defined above.}
\item{thin, n.chains}{As defined above.}
\item{call}{Function call.}
\item{version}{Version of R package \bold{crossnma} used to create
  object.}
}
\description{
This function takes the JAGS model from an object produced by
\code{\link{crossnma.model}} and runs it using \code{jags.model} in
rjags package.
}
\examples{
\dontrun{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
stddata # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
set.seed(1909)
fit <- crossnma(mod)

# Display the output
summary(fit)
plot(fit)
}

}
\seealso{
\code{\link{crossnma.model}},
  \code{\link[rjags]{jags.model}}
}
\author{
Tasnim Hamza \email{tasnim.hamza@ispm.unibe.ch}, Guido
  Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
