% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_simulation_functions.R
\name{z_sim}
\alias{z_sim}
\title{Simulate marginal Z-scores from joint Z-score vector}
\usage{
z_sim(Zj, Sigma, nrep)
}
\arguments{
\item{Zj}{Vector of joint Z-scores (a vector of 0s except at the CV)}

\item{Sigma}{SNP correlation matrix}

\item{nrep}{Number of Z-score systems to simulate}
}
\value{
Matrix of simulated posterior probabilties, one simulation per row
}
\description{
Simulate marginal z-scores (\eqn{Z_m}) from the joint z-scores (\eqn{Z_j}) using \eqn{E(Z_m) = Z_j \times \Sigma} and
\eqn{Z* \sim MVN(E(Z_m), \Sigma)}
}
\examples{

set.seed(1)
nsnps <- 100

# derive joint Z score vector
Zj <- rep(0, nsnps)
iCV <- 4 # index of CV
mu <- 5 # true effect at CV
Zj[iCV] <- mu

## generate example LD matrix
library(mvtnorm)
nsamples = 1000

simx <- function(nsnps, nsamples, S, maf=0.1) {
    mu <- rep(0,nsnps)
    rawvars <- rmvnorm(n=nsamples, mean=mu, sigma=S)
    pvars <- pnorm(rawvars)
    x <- qbinom(1-pvars, 1, maf)
}

S <- (1 - (abs(outer(1:nsnps,1:nsnps,`-`))/nsnps))^4
X <- simx(nsnps,nsamples,S)
LD <- cor2(X)

res <- z_sim(Zj, Sigma = LD, nrep = 100)
res[c(1:5), c(1:5)]

}
\author{
Anna Hutchinson
}
