% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choosemaxit.R
\name{choosemaxit}
\alias{choosemaxit}
\title{Diagnostic plot for the number of iterations used in sequential imputation methods}
\usage{
choosemaxit(
  output,
  plotvars = NULL,
  plotm = 1:5,
  size = 0.5,
  linewidth = 1,
  linetype = "dotdash",
  xlab = "iterations",
  ylab = "var",
  title = "Within and between variance plots",
  nvar_by_row = 5
)
}
\arguments{
\item{output}{an outpout from the imputedata function}

\item{plotvars}{index of variables for which a curve is plotted}

\item{plotm}{a vector indicating which imputed datasets must be plotted}

\item{size}{size of points}

\item{linewidth}{a numerical value setting the widths of lines}

\item{linetype}{what type of plot should be drawn}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{title}{the main title}

\item{nvar_by_row}{the number of variables that are plotted per window. Default value is 5.}
}
\value{
No return value
}
\description{
The \code{choosemaxit} function plots the within and between variance for each variable (specified in \code{plotvars}) against the iteration number for each of the replications (specified in \code{plotm}).
}
\examples{
data(wine, package = "clusterMI")
set.seed(123456)
wine.na <- wine
wine.na$cult <- NULL
wine.na <- prodna(wine.na)
nb.clust <- 3 # number of clusters
m <- 3 # number of imputed data sets
maxit <- 50 # number of iterations for FCS imputation
\donttest{
res.imp <- imputedata(data.na = wine.na, method = "FCS-homo",
                      nb.clust = nb.clust, m = m, maxit = maxit)
choosemaxit(res.imp)
}
}
