% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnormGpu.R
\name{rnormGpu}
\alias{rnormGpu}
\title{rnormGpu}
\usage{
rnormGpu(
  n,
  streams,
  Nglobal = getOption("clrng.Nglobal"),
  type = getOption("clrng.type"),
  verbose = FALSE
)
}
\arguments{
\item{n}{a number or a vector specifying the size of output vector or matrix.}

\item{streams}{a vclMatrix of streams.}

\item{Nglobal}{a (non-empty) integer vector specifying size of work items for use, with default value from global option 'clrng.Nglobal'.}

\item{type}{a character string specifying "double" or "float" of random numbers, with default value from global option 'clrng.type'.}

\item{verbose}{a logical value, if TRUE, print extra information, default is FALSE.}
}
\value{
a 'vclVector' or 'vclMatrix' of standard Normal random numbers.
}
\description{
Generate standard Normal random numbers parallely on a GPU.
}
\details{
\code{type} specifies the precision type of random numbers. If GPU supports "double", 'clrng.Nglobal' is "double", otherwise, `clrng.Nglobal' is "single".
}
\examples{
library(clrng)
if (detectGPUs() >= 1) {
  setContext(grep("gpu", listContexts()$device_type)[1])
  currentPlatform()
  streams <- createStreamsGpu()
  as.vector(rnormGpu(7, streams=streams))

  getOption('clrng.Nglobal')
  # use float precision and global size
  as.matrix(rnormGpu(c(2,3), streams=streams))} else {
  message("No GPU context available")
}

}
