% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctg_bulk_fetch.R
\name{ctg_bulk_fetch}
\alias{ctg_bulk_fetch}
\title{Bulk Fetch Clinical Trial Data from ClinicalTrials.gov API}
\usage{
ctg_bulk_fetch(
  condition = NULL,
  location = NULL,
  title = NULL,
  intervention = NULL,
  status = NULL
)
}
\arguments{
\item{condition}{Character string specifying the condition to search for.}

\item{location}{Character string specifying the location to search in.}

\item{title}{Character string specifying the title to search for.}

\item{intervention}{Character string specifying the intervention to search for.}

\item{status}{A character vector specifying the recruitment status of the trials. Allowed values are:
Valid values include:
\itemize{
  \item \code{ACTIVE_NOT_RECRUITING} - Studies that are actively conducting but not
        recruiting participants.
  \item \code{COMPLETED} - Studies that have completed all phases.
  \item \code{ENROLLING_BY_INVITATION} - Studies that are enrolling participants
        by invitation only.
  \item \code{NOT_YET_RECRUITING} - Studies that have not yet started recruiting.
  \item \code{RECRUITING} - Studies that are actively recruiting participants.
  \item \code{SUSPENDED} - Studies that are temporarily halted.
  \item \code{TERMINATED} - Studies that have been terminated before completion.
  \item \code{WITHDRAWN} - Studies that have been withdrawn before enrollment.
  \item \code{AVAILABLE} - Studies that are available.
  \item \code{NO_LONGER_AVAILABLE} - Studies that are no longer available.
  \item \code{TEMPORARILY_NOT_AVAILABLE} - Studies that are temporarily not available.
  \item \code{APPROVED_FOR_MARKETING} - Studies that have been approved for marketing.
  \item \code{WITHHELD} - Studies that have data withheld.
  \item \code{UNKNOWN} - Studies with an unknown status.
}}
}
\value{
A data frame containing the fetched clinical trial data.
}
\description{
This function retrieves clinical trial data in bulk from the ClinicalTrials.gov API based on
specified parameters. It handles pagination and returns a combined dataset.
}
\examples{
\donttest{
trials <- ctg_bulk_fetch(location="india")
}
}
