% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciu-package.r
\docType{package}
\name{ciu-package}
\alias{ciu-package}
\alias{_PACKAGE}
\title{ciu: Contextual Importance and Utility}
\description{
Implementation of the Contextual Importance and Utility (CIU) concepts for Explainable AI (XAI). A recent description of CIU can be found in e.g. Främling (2020) \href{https://arxiv.org/abs/2009.13996}{arXiv:2009.13996}.
}
\details{
This package implements the Contextual Importance and Utility (CIU)
concepts for Explainable AI (XAI).
CIU allows explaining output values of any regression or
classification systems, no matter if it is a "black-box" or a "white-box"
AI, or anything between black and white. CIU is entirely
model-agnostic. Contrary to most (all?) other XAI methods, CIU provides
explanations directly based on the observed input-output behavior without
building an intermediate "interpretable" model for doing it.

CIU was developed by Kary Främling in his PhD thesis, which was presented
in 1996 (in French). CIU was first presented in 1995 at the International
Conference on Artificial Neural Networks (ICANN).

The ciu package supports models from \code{caret} and at least \code{lda} natively,
but can easily be made to work with any model.

\strong{Main functions:}

Use of \code{ciu} starts by calling the function \link{ciu.new} that returns an object
of class \code{CIU}. If the \code{CIU} object is created by \code{ciu <- ciu.new(...)},
then different methods can be called as \code{ciu$explain()},
\code{ciu$barplot.ciu()} etc. for obtaining explanations in different forms.

\code{ciu} is implemented using an "old style" (?) R object orientation. However,
it provides object-oriented encapsulation of variables and methods of the
\code{CIU} object, which presumably helps to avoid name conflicts with other
packages or user code.

Since version 0.5.0 it is also possible to use a non-object-oriented approach
by creating an ordinary \link{list} of class \code{ciu} by calling the function \link{ciu}.
That \code{ciu} object is then
passed as the first parameter to the different functions. This parallel
possibility was originally developed mainly for getting support for proper
Roxygen functionality. However, it does also offer some interesting properties,
e.g. a \code{CIU} object takes up much more memory than a \code{ciu} object because it
creates its own environment. \code{CIU} objects can be converted to \code{ciu} objects
and vice versa at any time by the \verb{<CIU>$as.ciu()} method and the \link{ciu.to.CIU}
function.

It is recommended to use the object-oriented approach in order to
avoid unnecessary conversions back and forth. However, the difference is
presumably not very significant.
}
\references{
Främling, K. \emph{Explainable AI without Interpretable Model}. 2020, \url{https://arxiv.org/abs/2009.13996}.

Främling, K. \emph{Decision Theory Meets Explainable AI}. 2020, <doi.org/10.1007/978-3-030-51924-7_4>.

Främling, K. \emph{Modélisation et apprentissage des préférences par réseaux de neurones pour l'aide à la décision multicritère}. 1996, \url{https://tel.archives-ouvertes.fr/tel-00825854/document} (title translation in English: \emph{Learning and Explaining Preferences with Neural Networks for Multiple Criteria Decision Making})
}
